#include <bits/stdc++.h>

using namespace std;

double Angle(pair<long long int, long long int> t, pair<long long int, long long int> c){
    return atan2(c.second - t.second, c.first - t.first);
}

void Sort(vector<pair<long long int, long long int>> &dot, pair<long long int, long long int> cent)
{
    for(int i = 0; i < dot.size(); i++)
        for(int j = i; j < dot.size(); j++)
            if(Angle(dot[i], cent) > Angle(dot[j], cent))
                swap(dot[j], dot[i]);
}

long long int Shoelace(vector<pair<long long int, long long int>> dot)
{
    long long int p = 0LL;
    for(int i = 0; i < dot.size(); i++)
    {
        p += dot[i].first * dot[(i+1) % dot.size()].second;
        p -= dot[i].second * dot[(i+1) % dot.size()].first;
    }
    return abs(p) / 2;
}

int main()
{
    std::ios::sync_with_stdio(false);
    int n, k;
    double centx = 0, centy = 0;
    long long int x, y, p, p1;
    cin >> n;
    vector<pair<long long int, long long int>> dot(n, make_pair(0, 0)), dot1;
    for(int i = 0; i < n; i++)
    {
        cin >> x >> y;
        dot[i].first = x;
        dot[i].second = y;
        centx += x;
        centy += y;
    }
    centx = (double)centx / n;
    centy = (double)centy / n;
    Sort(dot, make_pair(centx, centy));
    dot1.resize(n-1, make_pair(0, 0));
    p = Shoelace(dot);
    for(int i = 0; i < n; i++)
    {
        k = 0;
        for(int j = 0; j < n; j++)
        {
            if(j == i)
                continue;
            dot1[k++] = dot[j];
        }
        p1 = Shoelace(dot1);
        if(p1 < p)
            p = p1;
    }
    cout << p;
    return 0;
}